attribute vec4 position; 
attribute vec2 texcoord;

uniform mat4 viewproj; 
uniform vec3 eyePos;

varying vec2 tc; 
varying vec3 viewDir; 

void main()
{
	vec4 pos = vec4((position.xy-.5)*vec2(2.0, 1.0)*40.0, 0.0, 1.0);
	gl_Position = viewproj*pos; 
	tc = texcoord; 
	tc.y = .25-tc.y*.25;
	viewDir = pos.xyz-eyePos;
}

//FRAGMENT

uniform sampler2D Texture0; //Logo 
uniform samplerCube Texture1; //Background
uniform sampler2D Texture2; //Lines
uniform float time;
varying vec2 tc; 

varying vec3 viewDir; 
uniform float tracks[32]; 
// 11: textureOffset
// 12: noisePhase
// 13: colorMul


float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main()
{
	// set current texture slide
	vec2 ntc = tc; 
	ntc.y += tracks[11]*.25;

	//Line Noise Text effect
	float noisePhase = tracks[12]; 
	float a = .8*clamp(sin(noisePhase), 0.0, 1.0);
	ntc.x += a*.0225*cos(tc.y*32*100.0+noisePhase*5.3);

	// create lame lines
	vec2 g0 = (tc+vec2(0.0, time*0.4+ntc.x*4))*vec2(1.0, 30.0);
	float lines = 1.0-texture2D(Texture2, g0);

	vec2 break_off = vec2(((tc.x+tc.y)-mod(tc.x+tc.y, .0001120))/2.0);
	vec2 tc_rand = .25* rand(vec2(sin(break_off.x*.01), cos(break_off.y*3.3)));
	vec4 shape = texture2D(Texture0, ntc);

	// colorize
	vec4 p = textureCube(Texture1, normalize(viewDir));//texture2D(Texture1, gl_FragCoord.xy/vec2(2560, 1440));
	vec4 bg_blend = 2.0*pow(p, vec4(0.8)) + 5.0*pow(p, vec4(1.8));

	gl_FragColor = shape;
	gl_FragColor.rgb = bg_blend*shape.a;

	gl_FragColor.rgb += bg_blend*1.0 *(1.0-shape.a);

	gl_FragColor.rgb *= tracks[13];
	if(tracks[13] < 1.0)
		gl_FragColor.a *= tracks[13];

	gl_FragColor = pow(gl_FragColor, vec4(1.6));
	//gl_FragColor = p;
}
